/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;

class IntQueue {
    private int size = 0;
    private int[] data = null;
    private int front = 0;
    private int back = 0;

    protected IntQueue(int theSize) {
        this.size = theSize + 1;
        this.data = new int[this.size];
    }

    protected boolean isEmpty() {
        return this.front == this.back;
    }

    protected boolean isFull() {
        return (this.back + 1) % this.size == this.front;
    }

    protected void put(int theValue) throws VWException {
        if (this.isFull()) {
            throw new VWException("vw.api.VWMapDefinitionQueueIsFull", "Attempt to add to a full Queue.");
        }
        this.data[this.back] = theValue;
        this.back = (this.back + 1) % this.size;
    }

    protected int get() throws VWException {
        if (this.isEmpty()) {
            throw new VWException("vw.api.VWMapDefinitionQueueIsEmpty", "Attempt to get from an empty Queue.");
        }
        int rval = this.data[this.front];
        this.front = (this.front + 1) % this.size;
        return rval;
    }
}

